package com.biz.crm.workflow.sdk.event.log;

import com.biz.crm.workflow.sdk.dto.BpmMnProcessCorrelationLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;
import java.util.List;

/**
 * 蒙牛关联流程实例变更事件通知接口
 *
 * @author liuyifan
 * @date 2023-02-06 12:50:45
 */
public interface BpmMnProcessCorrelationLogEventListener extends NebulaEvent {

    /**
     * 创建日志事件
     */
    void onCreate(BpmMnProcessCorrelationLogEventDto eventDto);

    /**
     * 删除日志事件
     *
     * @param eventDto
     */
    void onDelete(BpmMnProcessCorrelationLogEventDto eventDto);

    /**
     * 更新日志事件
     *
     * @param eventDto
     */
    void onUpdate(BpmMnProcessCorrelationLogEventDto eventDto);

    /**
     * 启用日志事件
     *
     * @param eventDto
     */
    void onEnable(BpmMnProcessCorrelationLogEventDto eventDto);

    /**
     * 禁用日志事件
     *
     * @param eventDto
     */
    void onDisable(BpmMnProcessCorrelationLogEventDto eventDto);

}
