package com.biz.crm.workflow.sdk.event.log;

import com.biz.crm.workflow.sdk.dto.BpmMnProcessTaskCorrelationLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;
import java.util.List;

/**
 * 蒙牛关联流程任务实例变更事件通知接口
 *
 * @author liuyifan
 * @date 2023-02-06 17:26:03
 */
public interface BpmMnProcessTaskCorrelationLogEventListener extends NebulaEvent {

    /**
     * 创建日志事件
     */
    void onCreate(BpmMnProcessTaskCorrelationLogEventDto eventDto);

    /**
     * 删除日志事件
     *
     * @param eventDto
     */
    void onDelete(BpmMnProcessTaskCorrelationLogEventDto eventDto);

    /**
     * 更新日志事件
     *
     * @param eventDto
     */
    void onUpdate(BpmMnProcessTaskCorrelationLogEventDto eventDto);

    /**
     * 启用日志事件
     *
     * @param eventDto
     */
    void onEnable(BpmMnProcessTaskCorrelationLogEventDto eventDto);

    /**
     * 禁用日志事件
     *
     * @param eventDto
     */
    void onDisable(BpmMnProcessTaskCorrelationLogEventDto eventDto);

}
