package com.biz.crm.workflow.sdk.listener;

import com.biz.crm.workflow.sdk.dto.UserInfoEventDto;
import com.biz.crm.workflow.sdk.vo.response.UserInfoResponse;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * 描述：</br>用户信息事件类，接入工作流模块需提供此数据
 * 为审批人选择提供用户信息
 *
 * @author longhuajiang
 * @date: 2023/1/12
 */
public interface OrgUserListener extends NebulaEvent {

  /**
   * 查询指定企业组织上级组织的所有人员
   *
   * @param: * @param null
   * @return: * @return: null
   * @author: longhuajiang
   * @date: 2023/1/11
   */
  UserInfoResponse findOrgUpperLowerByUserCode(UserInfoEventDto dto);

  /**
   * 查询指定企业组织祖级组织的所有人员
   *
   * @param: * @param null
   * @return: * @return: null
   * @author: longhuajiang
   * @date: 2023/1/18
   */
   UserInfoResponse findGreatGrandFatherByUserCode(UserInfoEventDto dto);

}
