package com.biz.crm.workflow.sdk.listener;

import com.biz.crm.workflow.sdk.vo.ProcessButtonGroupVo;

/**
 * @description: 流程按钮组;(bpm_process_button_group)相关的事件通知
 * @author: rentao
 * @date: 2022/7/29 14:21
 */
public interface ProcessButtonGroupEventListener {
  /**
   * 当流程按钮组数据被创建时，该事件被触发
   * @param bpmProcessButtonGroupVo
   */
  void onCreated(ProcessButtonGroupVo bpmProcessButtonGroupVo);
  /**
   * 当流程按钮组数据被修改时，该事件被触发
   * @param oldBpmProcessButtonGroupVo 修改前数据
   * @param bpmProcessButtonGroupVo  修改后数据
   */
  void onUpdate(ProcessButtonGroupVo oldBpmProcessButtonGroupVo, ProcessButtonGroupVo bpmProcessButtonGroupVo);
  /**
   * 当流程按钮组数据被删除时（逻辑删除），该事件被触发
   * @param bpmProcessButtonGroupVo
   */
  void onDeleted(ProcessButtonGroupVo bpmProcessButtonGroupVo);
}
