package com.biz.crm.workflow.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;

import com.biz.crm.workflow.sdk.dto.BpmMnProcessCorrelationDto;
import com.biz.crm.workflow.sdk.vo.BpmMnProcessCorrelationVo;
import com.biz.crm.workflow.sdk.vo.BpmMnProcessResponseVo;
import org.springframework.data.domain.Pageable;

/**
 * 蒙牛关联流程实例(BpmMnProcessCorrelation)表服务接口
 *
 * @author liuyifan
 * @date 2023-02-06 12:50:45
 */
public interface BpmMnProcessCorrelationVoService {

    /**
     * 分页条件查询
     *
     * @param pageable
     * @param dto
     * @return
     */
    Page<BpmMnProcessCorrelationVo> findByConditions(Pageable pageable, BpmMnProcessCorrelationDto dto);

    /**
     * 按id查询详情
     *
     * @param id
     * @return
     */
    BpmMnProcessCorrelationVo findDetailById(String id);

    /**
     * 创建
     *
     * @param bpmMnProcessCorrelationVo
     * @return
     */
    BpmMnProcessCorrelationVo create(BpmMnProcessCorrelationVo bpmMnProcessCorrelationVo);

    /**
     * 更新
     *
     * @param bpmMnProcessCorrelationVo
     * @return
     */
    BpmMnProcessCorrelationVo update(BpmMnProcessCorrelationVo bpmMnProcessCorrelationVo);

    /**
     * 根据蒙牛实例id获取vo
     *
     * @param mnInstanceId
     *            mn实例id
     * @return {@link BpmMnProcessCorrelationVo}
     */
    BpmMnProcessResponseVo findByMnInstanceId(String mnInstanceId, String mnTaskId, String viewType);
}
