package com.biz.crm.workflow.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.workflow.sdk.dto.BpmMnProcessTaskCorrelationDto;
import java.util.List;

import com.biz.crm.workflow.sdk.vo.BpmMnProcessTaskCorrelationVo;
import org.springframework.data.domain.Pageable;

/**
 * 蒙牛关联流程任务实例(BpmMnProcessTaskCorrelation)表服务接口
 *
 * @author liuyifan
 * @date 2023-02-06 17:26:02
 */
public interface BpmMnProcessTaskCorrelationVoService {

    /**
     * 分页条件查询
     *
     * @param pageable
     * @param dto
     * @return
     */
    Page<BpmMnProcessTaskCorrelationVo> findByConditions(Pageable pageable, BpmMnProcessTaskCorrelationDto dto);

    /**
     * 按id查询详情
     *
     * @param id
     * @return
     */
    BpmMnProcessTaskCorrelationVo findDetailById(String id);

    /**
     * 创建
     *
     * @param bpmMnProcessTaskCorrelationVo
     * @return
     */
    BpmMnProcessTaskCorrelationVo create(BpmMnProcessTaskCorrelationVo bpmMnProcessTaskCorrelationVo);

    /**
     * 更新
     *
     * @param bpmMnProcessTaskCorrelationVo
     * @return
     */
    BpmMnProcessTaskCorrelationVo update(BpmMnProcessTaskCorrelationVo bpmMnProcessTaskCorrelationVo);


    /**
     * 根据mn任务id获取
     *
     * @param mnTaskId mn任务id
     * @return {@link BpmMnProcessTaskCorrelationVo}
     */
    BpmMnProcessTaskCorrelationVo findByMnTaskId(String mnTaskId);
}
