package com.biz.crm.workflow.sdk.service;


import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;

/**
 * 流程操作流程，提供给client客户端进行流程发起流程功能-批量提交
 * 流程发起通过businessCode进行业务模块之间的数据隔离，每个业务模块的businessNo需要保证其唯一性
 *
 * @author keller
 */
public interface ProcessBatchBusinessService {

    /**
     * 业务端发起流程调用方法
     * 内部对发起流程调用流程引擎的方法进行了封装
     *
     * @param dto
     */
    ProcessBusinessVo processStart(ProcessBusinessDto dto);

    /**
     * 创建流程
     *
     * @param dto
     * @return
     */
    ProcessBusinessVo create(ProcessBusinessDto dto);

    /**
     * 开始流程
     *
     * @param dto
     */
    void start(ProcessBusinessDto dto);
}
