package com.biz.crm.workflow.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessMappingDto;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessMappingVo;
import liquibase.pro.packaged.S;
import org.springframework.data.domain.Pageable;

import javax.transaction.Transactional;
import java.util.Collection;
import java.util.List;

/**
 * 业务流程关联表;(bpm_process_business_mapping)表服务接口
 *
 * @author : Keller
 * @date : 2022-8-24
 */
public interface ProcessBusinessMappingService {

  /**
   * 分页查询数据
   *
   * @param pageable 分页对象
   * @param dto      实体对象
   */
  Page<ProcessBusinessMappingVo> findByConditions(Pageable pageable, ProcessBusinessMappingDto dto);

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  ProcessBusinessMappingVo findById(String id);

  /**
   * 通过主键查询多条数据
   *
   * @param ids 主键集合
   * @return 多条数据
   */
  List<ProcessBusinessMappingVo> findByIds(Collection<String> ids);

  /**
   * 新增数据
   *
   * @param processBusinessMappingDto 实体对象
   * @return 新增结果
   */
  ProcessBusinessMappingVo create(ProcessBusinessMappingDto processBusinessMappingDto);
  /**
   * 批量新增数据
   *
   * @param processBusinessMappingDtoList 实体对象集合
   * @return 新增结果
   */
  List<ProcessBusinessMappingVo> create(List<ProcessBusinessMappingDto> processBusinessMappingDtoList);

  /**
   * 根据业务编号及流程状态查询关联数据信息
   *
   * @param processBusinessNo
   * @param processStatus
   * @return
   */
  ProcessBusinessMappingVo findProcessByBusinessNoAndBusinessCodeAndProcessKeyAndProcessStatus(String processBusinessNo, String processBusinessCode, String processKey, String processStatus);

  /**
   * 根据业务编号集合及流程状态查询关联数据信息
   *
   * @param processBusinessNo
   * @param processStatus
   * @return
   */
  List<ProcessBusinessMappingVo> findProcessByBusinessNoAndBusinessCodeAndProcessKeyAndProcessStatus(List<String> processBusinessNo, String processBusinessCode, String processKey, String processStatus);

  /**
   * 根据id更新流程状态
   *
   * @param id
   * @param processStatus
   */
  void updateProcessStatusById(String id, String processStatus);
  void updateProcessStatusById(List<String> id, String processStatus);

  /**
   * 更新流程的表单的可编辑状态
   *
   * @param id
   * @param canEdit
   * @param taskId
   * @param taskName
   */
  void updateCanEditById(String id, Boolean canEdit, String taskId, String taskName);

  void updateCanEditByIds(List<String> ids, Boolean canEdit, String taskId, String taskName);

  /**
   * 通过业务流程编号以及业务编号查询
   *
   * @param dto
   * @return
   */
  ProcessBusinessMappingVo findSignalByConditions(ProcessBusinessMappingDto dto);

  /**
   * 通过业务流程编号以及业务编号查询
   *
   * @param dto
   * @return
   */
  List<ProcessBusinessMappingVo> findMultiByByConditions(ProcessBusinessMappingDto dto);

  /**
   * 通过InstanceId查询所有拥有相同业务数据的记录
   *
   * @param processNo processNo
   * @return
   */
  List<ProcessBusinessMappingVo> findAllRelationalByProcessNo(String processNo);

  /**
   * 逻辑删除数据
   */
  void deleteByBusinessNoAndBusinessCodeAndProcessKey(String processBusinessNo, String processBusinessCode, String processKey);

  /**
   * 逻辑删除数据
   */
  void deleteByBusinessNoAndBusinessCodeAndProcessKey(List<String> processBusinessNoList, String processBusinessCode, String processKey);

}
