package com.biz.crm.workflow.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.workflow.sdk.dto.ProcessTemplateNodeDto;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeVo;
import org.springframework.data.domain.Pageable;

import java.util.Collection;
import java.util.List;

/**
 * 流程节点;(bpm_process_template_node)表服务接口
 * @author : Keller
 * @date : 2022-7-29
 */
public interface ProcessTemplateNodeService{

  /**
   * 分页查询数据
   *
   * @param pageable        分页对象
   * @param dto 实体对象
   */
  Page<ProcessTemplateNodeVo> findByConditions(Pageable pageable, ProcessTemplateNodeDto dto);
  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  ProcessTemplateNodeVo findById(String id);
  /**
   * 通过主键查询多条数据
   *
   * @param ids 主键集合
   * @return 多条数据
   */
  List<ProcessTemplateNodeVo> findByIds(Collection<String> ids);
  /**
   * 新增数据
   *
   * @param processTemplateNodeDto 实体对象
   * @return 新增结果
   */
  ProcessTemplateNodeVo create(ProcessTemplateNodeDto processTemplateNodeDto);
  /**
   * 批量新增
   * @param processTemplateNodeDtos
   * @return
   */
  List<ProcessTemplateNodeVo> createBatch(Collection<ProcessTemplateNodeDto> processTemplateNodeDtos);

  /**
   * 删除数据
   *
   * @param ids 主键结合
   */
  void delete(Collection<String> ids);

  /**
   * 根据模板编号删除所有节点数据
   * @param templateId
   */
  void deleteByTemplateId(String templateId);

  /**
   * 根绝业务编号templateId获取业务数据
   *
   * @param templateId
   * @return 多条数据
   */
  List<ProcessTemplateNodeVo> findByTemplateId(String templateId);

  /**
   * 根绝业务编号templateId获取业务数据
   *
   * @param templateId
   * @return 多条数据
   */
  ProcessTemplateNodeVo findByTemplateIdAndTaskId(String templateId,String taskId);

  /**
   * 根据流程定义编号获取业务数据
   *
   * @param processDefinitionId
   * @return 多条数据
   */
  List<ProcessTemplateNodeVo> findByProcessDefinitionId(String processDefinitionId);

  /**
   * 根据流程实例id获取流程模板节点数据
   *
   * @param processDefinitionId
   * @return 多条数据
   */
  List<ProcessTemplateNodeVo> findByProcessInstanceId(String processDefinitionId);

  /**
   * 根绝业务编号templateIds获取业务数据
   *
   * @param templateIds
   * @return 多条数据
   */
  List<ProcessTemplateNodeVo> findByTemplateIds(Collection<String> templateIds);

  /**
   * 根绝流程定义的id与节点id查询业务数据
   * @param processDefinitionId
   * @param taskDefinitionKey
   * @return
   */
  ProcessTemplateNodeVo findByProcessDefinitionIdAndTaskDefinitionKey(String processDefinitionId, String taskDefinitionKey);

  /**
   * 根绝流程实例的id与节点id查询业务数据
   * @param processInstanceId
   * @param taskDefinitionKey
   * @return
   */
  ProcessTemplateNodeVo findByProcessInstanceIdAndTaskDefinitionKey(String processInstanceId, String taskDefinitionKey);

}
