package com.biz.crm.workflow.sdk.strategy.sms;

import com.biz.crm.workflow.sdk.dto.ProcessTemplateNodeSmsUserDto;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeSmsUserVo;

import java.util.Collection;
import java.util.Set;

/**
 * @description: 短信平台收件人策略
 * @author: rentao
 * @date: 2022/8/4 10:50
 */
public interface SmsToUserStrategy {

  /**
   * 短信平台收件人策略编码
   * @return
   */
  String getSmsToUserTypeCode();

  /**
   * 短信平台收件人策略名称
   * @return
   */
  String getSmsToUserTypeName();

  /**
   * 获取手机号
   * @return
   */
  Set<String> getSmsPhone(Collection<ProcessTemplateNodeSmsUserVo> processTemplateNodeSmsUserVos);

  /**
   * 新增
   */
  void onSaveSmsToUserBatchInfo(Collection<ProcessTemplateNodeSmsUserDto> processTemplateNodeSmsUserDtos);
}
