package com.biz.crm.workflow.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 职位基础信息VO,接入
 *
 * @author ning.zhang
 * @date 2021/10/13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "职位表")
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class PositionVo  {

  private static final long serialVersionUID = 7281844844093831468L;
  /**
   * 职位编码
   */
  @ApiModelProperty("职位编码")
  private String positionCode;
  /**
   * 职位名称
   */
  @ApiModelProperty("职位名称")
  private String positionName;
  /**
   * 上级职位编码
   */
  @ApiModelProperty("上级职位编码")
  private String parentCode;
  /**
   * 职位级别编码
   */
  @ApiModelProperty("职位级别编码")
  private String positionLevelCode;
  /**
   * 关联角色编码
   */
  @ApiModelProperty("关联角色编码")
  private List<String> roleList;

  /**
   * 组织编码
   */
  @ApiModelProperty("组织编码")
  private String orgCode;

  /**
   * 组织名称
   */
  @ApiModelProperty("组织名称")
  private String orgName;

  /**
   * 关联用户名称
   */
  @ApiModelProperty("关联用户名称")
  private String userName;
}
