package com.biz.crm.workflow.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.bizunited.nebula.common.vo.TenantVo;
import lombok.Getter;
import lombok.Setter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.io.Serializable;
import java.util.Date;

/**
 * Vo：流程抄送记录;
 * @author : jerry7
 * @date : 2022-8-15
 */
@ApiModel(value = "ProcessTaskCopyEntity",description = "流程抄送记录")
@Getter
@Setter
public class ProcessTaskCopyVo extends TenantFlagOpVo {
  /** 主键 */
  @ApiModelProperty(name = "id",notes = "主键", value= "主键")
  private String id;
  /** 流程名称 */
  @ApiModelProperty(name = "processName",notes = "流程名称", value= "流程名称")
  private String processName;
  /** 抄送人职位编码 */
  @ApiModelProperty(name = "positionCode",notes = "抄送人职位编码", value= "抄送人职位编码")
  private String positionCode;
  /** 流程实例id */
  @ApiModelProperty(name = "processInstanceId",notes = "流程实例id", value= "流程实例id")
  private String processInstanceId;
  /** business_form_no */
  @ApiModelProperty(name = "businessFormNo",notes = "业务编码", value= "业务编码")
  private String businessFormNo;
  /** 流程标题 */
  @ApiModelProperty(name = "processTitle",notes = "流程标题", value= "流程标题")
  private String processTitle;
  /** 发起用户编码 */
  @ApiModelProperty(name = "commitUserCode",notes = "任务发起用户编码", value= "任务发起用户编码")
  private String commitUserCode;
  /** 发起用户名称 */
  @ApiModelProperty(name = "commitUserName",notes = "发起用户名称", value= "发起用户名称")
  private String commitUserName;
  /** 发起时间 */
  @ApiModelProperty(name = "commitTime",notes = "发起时间", value= "发起时间")
  private Date commitTime;
  /** 流程key */
  @ApiModelProperty(name = "processKey",notes = "流程key", value= "流程key")
  private String processKey;

  /** 任务id */
  @ApiModelProperty(name = "taskId",notes = "任务id", value= "任务id")
  private String taskId;

  /** 任务名称 */
  @ApiModelProperty(name = "taskName",notes = "任务id", value= "任务名称")
  private String taskName;

  /** 抄送人用户编码 */
  @ApiModelProperty(name = "userCode",notes = "抄送人用户编码", value= "抄送人职位编码")
  private String userCode;

  /** 流程状态 */
  @ApiModelProperty(name = "processStatus",notes = "流程状态", value= "流程状态")
  private String processStatus;


}