package com.biz.crm.workflow.sdk.vo;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * Vo：流程节点;
 * @author : Keller
 * @date : 2022-7-28
 */
@ApiModel(value = "ProcessTemplateNode",description = "流程节点")
@Getter
@Setter
public class ProcessTemplateNodeVo implements Serializable {
  /** 主键 */
  @ApiModelProperty(name = "id",notes = "主键", value= "主键")
  private String id;
  /** 租户编号 */
  @ApiModelProperty(name = "tenantCode",notes = "租户编号", value= "租户编号")
  private String tenantCode;
  /** 创建时间 */
  @ApiModelProperty(name = "createTime",notes = "创建时间", value= "创建时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;
  /** 修改人名称 */
  @ApiModelProperty(name = "modifyName",notes = "修改人名称", value= "修改人名称")
  private String modifyName;
  /** 修改人账号 */
  @ApiModelProperty(name = "modifyAccount",notes = "修改人账号", value= "修改人账号")
  private String modifyAccount;
  /** 修改时间 */
  @ApiModelProperty(name = "modifyTime",notes = "修改时间", value= "修改时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  private Date modifyTime;
  /** 创建人名称 */
  @ApiModelProperty(name = "createName",notes = "创建人名称", value= "创建人名称")
  private String createName;
  /** 创建人账号 */
  @ApiModelProperty(name = "createAccount",notes = "创建人账号", value= "创建人账号")
  private String createAccount;
  /** 备注 */
  @ApiModelProperty(name = "remark",notes = "备注", value= "备注")
  private String remark;
  /** 流程任务编号 */
  @ApiModelProperty(name = "processTaskId",notes = "流程任务编号", value= "流程任务编号")
  private String processTaskId;
  /** 流程任务名称 */
  @ApiModelProperty(name = "processTaskName",notes = "流程任务名称", value= "流程任务名称")
  private String processTaskName;
  /** 流程任务说明 */
  @ApiModelProperty(name = "processTaskDoc",notes = "流程任务说明", value= "流程任务说明")
  private String processTaskDoc;
  /** 流程模板编号 */
  @ApiModelProperty(name = "templateId",notes = "流程模板编号", value = "流程模板编号")
  private String templateId;
  /** 编号 */
  @ApiModelProperty(name = "code",notes = "编号", value = "编号")
  private String code;
  /** 名称 */
  @ApiModelProperty(name = "name",notes = "名称", value = "名称")
  private String name;

  /** 流程节点扩展属性信息(json格式) */
  @ApiModelProperty(name = "attributes",notes = "流程节点扩展属性信息(json格式) ", value = "流程节点扩展属性信息(json格式) ")
  private JSONObject attributes;
}