package com.biz.crm.workflow.sdk.vo;

import com.biz.crm.business.common.sdk.dto.UuidDto;
import com.biz.crm.business.common.sdk.vo.UuidVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import lombok.Getter;
import lombok.Setter;


/**
 * @description: 流程适用范围vo
 * @author: rentao
 * @date: 2022/7/26 10:01
 */
@Getter
@Setter
@ApiModel(value = "ProcessTemplateScopeVo", description = "流程适用范围vo")
public class ProcessTemplateScopeVo extends UuidDto {

  /**
   * 流程模板id
   */
  @ApiModelProperty(name = "processTemplateId", notes = "流程模板id", value = "流程模板id")
  private String processTemplateId;

  /**
   * 适用范围  com.biz.crm.workflow.sdk.strategy.ApplicationUserScopeStrategy 策略中编码
   */
  @ApiModelProperty("适用范围类型")
  private String processUserScopeType;

  /**
   * 范围业务编码
   */
  @ApiModelProperty("范围业务编码")
  private String scopeCode;

  /**
   * 范围业务名称
   */
  @ApiModelProperty("范围业务名称")
  private String scopeName;
}
