package com.biz.crm.workflow.sdk.vo;

import com.biz.crm.business.common.sdk.vo.UuidVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.Set;

/**
 * @description: 流程xml vo
 * @author: rentao
 * @date: 2022/8/8 12:56
 */
@Getter
@Setter
@ApiModel(value = "ProcessTemplateXmlVo", description = "流程xml vo")
public class ProcessTemplateXmlVo extends UuidVo {

  /**
   * 流程模板id
   */
  @ApiModelProperty(name = "processTemplateId", notes = "流程模板id", value = "流程模板id")
  private String processTemplateId;

  /**
   * 流程模板xml
   */
  @ApiModelProperty(name = "processDesc", notes = "流程模板xml", value = "流程模板xml")
  private String processDesc;

  /**
   * 流程模板xml
   */
  @ApiModelProperty(name = "processHistoricVos", notes = "节点信息集合包含（当前和历史）", value = "节点信息集合包含（当前和历史）")
  private Set<ProcessHistoricVo> processHistorics;
}
