package com.biz.crm.workflow.sdk.vo.response;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.workflow.sdk.vo.UserVo;
import com.bizunited.nebula.event.sdk.model.EventResponse;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.Collection;

/**
 * 描述：</br>用户信息返回数据，接入工作流的模块需要针对工作流需要的数据进行返回
 *
 * @author keller
 * @date 2022/8/1
 */
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class UserInfoResponse extends EventResponse {

  /**
   * 用户信息
   */
  @ApiModelProperty("用户信息")
  private UserVo userVo;

  /**
   * 用户信息列表
   */
  @ApiModelProperty("用户信息列表")
  private Collection<UserVo> userVos;

  /**
   * 用户信息列表分页
   */
  @ApiModelProperty("用户信息列表分页")
  private Page<UserVo> userVoPage;
}
