package com.biz.crm.workflow.sdk.constant;

import com.google.common.collect.Lists;
import lombok.experimental.UtilityClass;

import java.util.List;

/**
 * @description: 流程管理常量
 * @author: rentao
 * @date: 2022/7/25 17:55
 */
@UtilityClass
public class ProcessConstant {

  public String process_key = "LCHZ";

  public String process_instance_no_key = "PROC";

  //按钮组
  public String PROCESS_BUTTON_GROUP_CODE = "ANZ";

  /**
   * 流程上下文默认参数key
   */
  public String PROCESS_INSTANCE_PARAM_CODE = "_defaultParam";

  /**
   * 流程上下文表单数据key
   */
  public String PROCESS_INSTANCE_FORM_DATA_CODE = "_formData";

  /**
   * 流程检测上下文表单数据key
   */
  public String PROCESS_VALIDATE_FORM_DATA_CODE = "formData";

  /**
   * 流程上下文业务操作key
   */
  public String PROCESS_INSTANCE_OPERATE_CODE = "_operate";

  /**
   * 流程上下文驳回原因
   */
  public String PROCESS_INSTANCE_REJECT_CONTENT = "_operate_reject_reason";

  /**
   * 或签值
   */
  public String PROCESS_SIGN_TYPE_SIGN = "sign";

  /**
   * 会签值
   */
  public String PROCESS_SIGN_TYPE_MULTI = "multi";

  /**
   * 当前操作按钮
   */
  public static final String CURRENT_OPERATE_BTN = "currentOperateBtn";

  /**
   * 用户任务
   */
  public static final String PROCESS_USER_TASK = "userTask";
  /**
   * 向前加签
   */
  public static final String BEFORE_ADD_SIGN = "before";

  /**
   * 委托配置
   */
  public static final String DELEGATE_CONFIG = "WTPZ";

  /**
   * 审批人
   */
  public static final String PROCESS_ASSIGNEE = "assignee";
  
  /**
   * 为空跳过设置默认操作人
   *
   * */
  public static final String SKIP_DEFAULT_CREATE_ACCOUNT = "跳过";

  /**
   * 节点跳过标识
   *
   * */
  public static final String TASK_SKIP_FLAG = "_skip";

  /**
   * 流程干预流程变量的名称
   */
  public static final String INTERVENTION = "_Intervention";

  /**
   * 流程干预超级管理员验签角色编码
   */
  public  static final String ROLE_CODE = "ADMIN";

  /**
   * 流程干预用户任务节点过滤编码
   */
  public static final String USER_TASK_NODE_CODE ="UserTaskProcessNode";


  /**
   * 流程干预用户任务节点过滤临时向后加签条件
   */
  public static final String DYNAMIC_PROCESS_TASK_NAME = "临时向后加签";

  /**
   * 上一节点审批人的上级策略编码
   */
  public static final String PRE_NODE_APPROVE_UPPER_TRACING_STRATEGY = "PreNodeApproverUpperTracingStrategy";

  /**
   * 预执行日志节点自定义key标记
   */
  public static final String PRE_EXECUTION_LOG_SIGN = "_preExecutionLogSign";

  /**
   * 用户节点是否可编辑
   */
  public static final String PROCESS_TASK_CAN_EDIT = "_canEdit";
}
