package com.biz.crm.workflow.sdk.dto;

import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

/**
 * 描述：</br>业务数据表单变动时间
 *
 * @author keller
 * @date 2022/8/12
 */
@Setter
@Getter
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class FormDataEventDto implements NebulaEventDto {

  /**
   * 业务编号
   */
  @ApiModelProperty("业务编号")
  private String businessNo;

  /**
   * 业务模块编号
   */
  @ApiModelProperty("业务模块编号")
  private String businessCode;

  /**
   * 流程key
   */
  @ApiModelProperty("流程key")
  private String processKey;

  /**
   * 流程编号
   */
  @ApiModelProperty("流程编号")
  private String processNo;

  /**
   * 租户编号
   */
  @ApiModelProperty("租户编号")
  private String tenantCode;
}
