package com.biz.crm.workflow.sdk.dto;

import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

/**
 * 描述：</br>流程状态变动数据dto
 *
 * @author keller
 * @date 2022/8/25
 */
@Getter
@Setter
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class ProcessStatusDto implements NebulaEventDto {
  /** 流程编号 */
  private String processNo;
  /** 流程key */
  private String processKey;
  /** 流程主题 */
  private String processTitle;
  /** 业务编号 */
  private String businessNo;
  /** 应用名称 */
  private String applicationName;
  /** 业务编号 */
  private String businessCode;
  /** 流程状态 */
  private String processStatus;
  /** 流程备注 */
  private String remark;
  /** 待审批人账号(逗号分隔) */
  private String candidateUserAccounts;
  /** 待审批人名称逗号分隔) */
  private String candidateUserNames;
  /** 租户信息 */
  private String tenantCode;
  /** 是否可编辑 */
  private Boolean canEdit;
  /** 流程节点编号 */
  private String taskId;
  /** 流程节点名称 */
  private String taskName;
}
