package com.biz.crm.workflow.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import lombok.Getter;
import lombok.Setter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.io.Serializable;
import java.util.Date;

/**
 * 参数传递dto：流程抄送记录;
 * @author : jerry7
 * @date : 2022-8-15
 */
@ApiModel(value = "ProcessTaskCopyEntity",description = "流程抄送记录")
@Getter
@Setter
public class ProcessTaskCopyDto extends TenantDto {
  /** 主键 */
  @ApiModelProperty(name = "id",notes = "主键", value = "主键")
  private String id;
  /** 流程名称 */
  @ApiModelProperty(name = "processName",notes = "流程名称", value = "流程名称")
  private String processName;
  /** 抄送人职位编码 */
  @ApiModelProperty(name = "positionCode",notes = "抄送人职位编码", value = "抄送人职位编码")
  private String positionCode;
  /** 流程实例id */
  @ApiModelProperty(name = "processInstanceId",notes = "流程实例id", value = "流程实例id")
  private String processInstanceId;
  /** business_form_no */
  @ApiModelProperty(name = "businessFormNo",notes = "业务编码", value = "业务编码")
  private String businessFormNo;
  /** 流程标题 */
  @ApiModelProperty(name = "processTitle",notes = "流程标题", value = "流程标题")
  private String processTitle;
  /** 发起用户编码 */
  @ApiModelProperty(name = "commitUserCode",notes = "任务发起用户编码", value = "任务发起用户编码")
  private String commitUserCode;
  /** 发起用户名称 */
  @ApiModelProperty(name = "commitUserName",notes = "发起用户名称", value = "发起用户名称")
  private String commitUserName;
  /** 发起时间 */
  @ApiModelProperty(name = "commitTime",notes = "发起时间", value = "发起时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date commitTime;
  /** 流程key */
  @ApiModelProperty(name = "processKey",notes = "流程key", value = "流程key")
  private String processKey;

  /** 任务id */
  @ApiModelProperty(name = "taskId",notes = "任务id", value= "任务id")
  private String taskId;

  /** 任务名称 */
  @ApiModelProperty(name = "taskName",notes = "任务id", value= "任务名称")
  private String taskName;

  /** 抄送人用户编码 */
  @ApiModelProperty(name = "userCode",notes = "抄送人用户编码", value= "抄送人职位编码")
  private String userCode;
  /**
   * 发起时间开始
   */
  @ApiModelProperty(name = "commitTimeStart", value = "发起时间开始")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date commitTimeStart;
  /**
   * 发起时间结束
   */
  @ApiModelProperty(name = "commitTimeEnd", value = "发起时间结束")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date commitTimeEnd;
  /** 发起用户名称*/
  @ApiModelProperty(name = "createName",notes = "用户名称", value = "用户名称")
  private String createName;
  /** 流程状态*/
  @ApiModelProperty(name = "processStatus",notes = "流程状态", value = "流程状态")
  private String processStatus;
  /** 业务表单编号*/
  @ApiModelProperty(name = "businessFormCode",notes = "业务表单编号", value = "业务表单编号")
  private String businessFormCode;

}