package com.biz.crm.workflow.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @author Kevin
 * @title ProcessTaskCopyStrategyDto
 * @date 2023/4/28 11:32
 * @description 流程抄送固定策略寻人详情dto
 */
@Getter
@Setter
@ApiModel("流程抄送固定策略寻人详情dto")
public class ProcessTaskCopyStrategyVarDto extends TenantDto {

  /**
   * 创建时间
   */
  @ApiModelProperty(name = "createTime", notes = "创建时间", value = "创建时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;
  /**
   * 创建人账号
   */
  @ApiModelProperty(name = "createAccount", notes = "创建人账号", value = "创建人账号")
  private String createAccount;
  /**
   * 创建人名称
   */
  @ApiModelProperty(name = "createName", notes = "创建人名称", value = "创建人名称")
  private String createName;
  /**
   * 修改人名称
   */
  @ApiModelProperty(name = "modifyName", notes = "修改人名称", value = "修改人名称")
  private String modifyName;
  /**
   * 修改人账号
   */
  @ApiModelProperty(name = "modifyAccount", notes = "修改人账号", value = "修改人账号")
  private String modifyAccount;
  /**
   * 修改时间
   */
  @ApiModelProperty(name = "modifyTime", notes = "修改时间", value = "修改时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  private Date modifyTime;
  /**
   * 节点代理人id
   */
  @ApiModelProperty(name = "nodeCopyId", notes = "节点抄送人id", value = "节点抄送人id")
  private String nodeCopyId;
  /**
   * 编号
   */
  @ApiModelProperty(name = "code", notes = "编号", value = "编号")
  private String code;
  /**
   * 名称
   */
  @ApiModelProperty(name = "name", notes = "名称", value = "名称")
  private String name;
  /**
   * 排序
   */
  @ApiModelProperty(name = "sort", notes = "排序", value = "排序")
  private Integer sort;

}
