package com.biz.crm.workflow.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Getter;
import lombok.Setter;

/**
 * @description: 流程绘制管理Dto
 * @author: rentao
 * @date: 2022/8/9 0:21
 */
@Getter
@Setter
@ApiModel(value = "ProcessTemplateDto", description = "流程绘制管理Dto")
public class ProcessTemplateDto extends TenantFlagOpDto {

  /**
   * 业务菜单编码  数据来源于表单引擎
   */
  @ApiModelProperty("流程编码")
  private String processKey;

  /**
   * 流程名称
   */
  @ApiModelProperty("流程名称")
  private String processName;

  /**
   * 发布状态 对应枚举 com.biz.crm.business.common.sdk.enums.EnableStatusEnum
   */
  @ApiModelProperty("发布状态 009 ")
  private String releaseStatus;

  /**
   * 流程关联业务dto
   */
  @ApiModelProperty(name = "processTemplateBusinessDto", notes = "流程关联业务dto", value = "流程关联业务dto")
  private ProcessTemplateBusinessDto processTemplateBusinessDto;

  /**
   * 流程xmldto
   */
  @ApiModelProperty(name = "processTemplateXmlDto", notes = "流程xmldto", value = "流程xmldto")
  private ProcessTemplateXmlDto processTemplateXmlDto;

  /**
   * 流程节点数据
   */
  @ApiModelProperty(name = "processTemplateNodes", notes = "流程节点数据", value = "流程节点数据")
  private List<ProcessTemplateNodeDto> processTemplateNodes;

  /**
   * 流程适用范围明细dto集合
   */
  @ApiModelProperty("流程适用范围明细dto集合")
  private List<ProcessTemplateScopeDto> processTemplateScopeDtos;

  /**
   * 流程检测发起人设置
   */
  @ApiModelProperty("流程检测发起人设置")
  private String submitUserCode;

}
