package com.biz.crm.workflow.sdk.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;

/**
 * 参数传递dto：流程节点邮件信息;
 * @author : Keller
 * @date : 2022-8-2
 */
@ApiModel(value = "ProcessTemplateNodeEmail",description = "流程节点邮件信息")
@Getter
@Setter
public class ProcessTemplateNodeEmailDto implements Serializable{
  /** 主键 */
  @ApiModelProperty(name = "id",notes = "主键", value = "主键")
  private String id;
  /** 租户编号 */
  @ApiModelProperty(name = "tenantCode",notes = "租户编号", value = "租户编号")
  private String tenantCode;
  /** 创建人账号 */
  @ApiModelProperty(name = "createAccount",notes = "创建人账号", value = "创建人账号")
  private String createAccount;
  /** 创建人名称 */
  @ApiModelProperty(name = "createName",notes = "创建人名称", value = "创建人名称")
  private String createName;
  /** 创建时间 */
  @ApiModelProperty(name = "createTime",notes = "创建时间", value = "创建时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;
  /** 流程模板编号 */
  @ApiModelProperty(name = "templateId",notes = "流程模板编号", value = "流程模板编号")
  private String templateId;
  /** 流程节点编号 */
  @ApiModelProperty(name = "nodeId",notes = "流程节点编号", value = "流程节点编号")
  private String nodeId;
  /** 发件人 */
  @ApiModelProperty(name = "fromUser",notes = "发件人", value = "发件人")
  private String fromUser;
  /** 收件人 */
  @ApiModelProperty(name = "toUser",notes = "收件人", value = "收件人")
  private String toUser;
  /** 抄送人 */
  @ApiModelProperty(name = "ccUser",notes = "抄送人", value = "抄送人")
  private String ccUser;
  /** 主题 */
  @ApiModelProperty(name = "subject",notes = "主题", value = "主题")
  private String subject;
  /** 内容 */
  @ApiModelProperty(name = "content",notes = "内容", value = "内容")
  private String content;
  /** 邮件附件 */
  @ApiModelProperty(name = "processTemplateNodeEmailFiles",notes = "邮件附件", value = "邮件附件")
  private Collection<ProcessTemplateNodeEmailFilesDto> processTemplateNodeEmailFiles;

}
