package com.biz.crm.workflow.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Collection;

/**
 * 参数传递dto：结束节点参数;
 *
 * @author : Keller
 * @date : 2022-8-9
 */
@ApiModel(value = "ProcessTemplateNodeEndTaskDto", description = "结束节点参数")
@Getter
@Setter
public class ProcessTemplateNodeEndTaskDto implements Serializable {

  /**
   * 主键
   */
  @ApiModelProperty(name = "id", notes = "主键", value = "主键")
  private String id;
  /**
   * 租户编号
   */
  @ApiModelProperty(name = "tenantCode", notes = "租户编号", value = "租户编号")
  private String tenantCode;
  /**
   * 流程模板编号
   */
  @ApiModelProperty(name = "templateId", notes = "流程模板编号", value = "流程模板编号")
  private String templateId;
  /**
   * 流程节点编号
   */
  @ApiModelProperty(name = "nodeId", notes = "流程节点编号", value = "流程节点编号")
  private String nodeId;
  /**
   * 抄送类型标记
   */
  @ApiModelProperty(name = "copyOptional", notes = "抄送类型标记", value = "抄送类型标记")
  private String copyOptional;
  /**
   * 抄送人信息
   */
  @ApiModelProperty(name = "processTaskCopyConfigs", notes = "抄送人信息", value = "抄送人信息")
  private Collection<ProcessTaskCopyConfigDto> processTaskCopyConfigs;
  /**
   * 结束节点抄送策略寻人配置
   */
  @ApiModelProperty(name = "processTaskCopyStrategy", notes = "结束节点抄送策略寻人配置", value = "结束节点抄送策略寻人配置")
  private Collection<ProcessTaskCopyStrategyDto> processTaskCopyStrategy;

}
