package com.biz.crm.workflow.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Set;
import lombok.Getter;
import lombok.Setter;

/**
 * @description: 流程绘制分页条件Dto
 * @author: rentao
 * @date: 2022/7/25 17:06
 */
@Getter
@Setter
@ApiModel(value = "ProcessTemplatePageDto", description = "流程绘制分页条件Dto")
public class ProcessTemplatePageDto  extends TenantFlagOpDto {

  /**
   * 流程编码
   */
  @ApiModelProperty("流程编码")
  private String processKey;

  /**
   * 流程名称
   */
  @ApiModelProperty("流程名称")
  private String processName;

  /**
   * 发布状态
   */
  @ApiModelProperty("发布状态")
  private String releaseStatus;

  /**
   * 是否最新
   */
  @ApiModelProperty("是否最新")
  private Boolean newest;

  /**
   * 流程编码集合
   */
  @ApiModelProperty("流程编码集合")
  private Set<String> processKeySet;

  /**
   * 业务菜单编码
   */
  @ApiModelProperty("业务菜单编码")
  private String businessCode;

  /**
   * 生效范围
   */
  @ApiModelProperty("生效范围")
  private String effectiveScope;

  /**
   * 流程编码精确查询
   */
  @ApiModelProperty("流程编码精确查询")
  private String processKeyPrecise;

}
