package com.biz.crm.workflow.sdk.dto;

import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.Collection;

/**
 * 描述：</br>用户信息Dto提供事件加载用户数据使用
 *
 * @author keller
 * @date 2022/8/1
 */
@Setter
@Getter
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class UserInfoEventDto implements NebulaEventDto {
  /**
   * 分页参数
   */
  @ApiModelProperty("分页参数")
  private int page;

  /**
   * 分页参数
   */
  @ApiModelProperty("分页参数")
  private int size;

  /**
   * 组织编码集合
   */
  @ApiModelProperty("组织编码集合")
  private Collection<String> orgCodes;

  /**
   * 职位编码集合
   */
  @ApiModelProperty("职位编码集合")
  private Collection<String> positionCodes;

  /**
   * 角色编码集合
   */
  @ApiModelProperty("角色编码集合")
  private Collection<String> roleCodes;

  /**
   * 职位级别编码集合
   */
  @ApiModelProperty("职位级别编码集合")
  private Collection<String> positionLevelCodes;

  /**
   * 用户编号集合
   */
  @ApiModelProperty("用户编号集合")
  private Collection<String> userCodes;

  /**
   * 用户名集合
   */
  @ApiModelProperty("用户名集合")
  private Collection<String> userNames;

  /**
   * 用户编号
   */
  @ApiModelProperty("用户编号")
  private String userCode;

  /**
   * 租户编号
   */
  @ApiModelProperty("租户编号")
  private String tenantCode;

}
