package com.biz.crm.workflow.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * 描述：</br>流程操作枚举
 * 提供流程操作的字典与枚举值
 *
 * @author keller
 * @date 2022/9/1
 */
@Getter
@AllArgsConstructor
public enum ProcessOperateTypeEnum {
  COMMIT("commit","commit","发起流程","0"),
  APPROVED("approved","approved","审批通过","1"),
  ASSIGNEE("assignee","assignee","转办","2"),
  COMMUNICATION("communication","communication","发起沟通","3"),
  COPY_SEND("copy_send","copy_send","抄送","4"),
  COUNTERSIGN("countersign","countersign","加签","5"),
  RECOVER("recover","recover","返回","6"),
  REJECT("reject","reject","追回","7"),
  REJECTED("rejected", "rejected", "驳回","12"),
  REPLY_COMMUNICATION("reply_communication","reply_communication","确认沟通","8"),
  RETRIEVE("retrieve","retrieve","取回","9"),
  ROLLBACK("rollback","rollback","回退","10"),
  UPLOAD("upload","upload","上传文件","11"),
  SKIP("skip","skip","跳过","12"),
  INTERVENE("intervene","intervene","干预","13"),
  INTERVENTION("Intervention","Intervention","流程干预","13"),
  ;


  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  /**
   * 根据编码返回流程状态名称
   *
   * @param key
   * @return
   */
  public static String getOperateNameByKey(String key) {
    if (Objects.nonNull(key)) {
     ProcessOperateTypeEnum[] values = ProcessOperateTypeEnum.values();
      for (ProcessOperateTypeEnum statusEnum : values) {
        if (statusEnum.getKey().equals(key)) {
          return statusEnum.getValue();
        }
      }
    }
    return null;
  }
}
