package com.biz.crm.workflow.sdk.listener;

import com.biz.crm.workflow.sdk.dto.OrgInfoDto;
import com.biz.crm.workflow.sdk.vo.response.OrgInfoResponse;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * 组织信息事件类，接入工作流模块需提供此数据
 *
 * @author jerry7
 * @date 2021/12/23 15:12
 */
public interface OrgInfoListener extends NebulaEvent {

  /**
   * 按orgCode集合查询
   *
   * @param dto 组织编码集合
   * @return 组织列表
   */
  OrgInfoResponse findByOrgCodes(OrgInfoDto dto);

  /**
   * 根据组织编码集合查询全部上级（含当前）组织列表
   *
   * @param dto 组织编码集合
   * @return 全部上级(含当前)组织列表
   */
  OrgInfoResponse findAllParentByOrgCodes(OrgInfoDto dto);

  /**
   * 根据条件分页查询组织列表
   *
   * @param dto 查询条件
   * @return 组织分页列表
   */
  OrgInfoResponse onFindByConditions(OrgInfoDto dto);


}
