package com.biz.crm.workflow.sdk.listener;

import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;

/**
 * 描述：</br>流程节点信息变更回调监听，该事件监听会通过businessCode进行区分，如果流程发起设置了businessCode，
 * 则只有配置了对应businessCode的监听才能获取到对应的通知
 *
 * 在进入用户节点的时候,通知当前节点的审批人和任务节点信息
 * 在完成或者删除用户节点的时候,通知清空当前节点的审批人和任务节点信息
 *
 * @author keller
 * @date 2022/8/25
 */
public interface ProcessChangeInfoListener {

  /**
   * 获取流程业务编号(默认为空)
   */
  String getBusinessCode();

  /**
   * 当流程开始后触发该事件
   */
  void onProcessChangeInfo(ProcessStatusDto dto);
}
