package com.biz.crm.workflow.sdk.listener;

import com.biz.crm.workflow.sdk.vo.ProcessTemplateVo;
import java.util.List;

/**
 * @description: 流程管理事件通知
 * @author: rentao
 * @date: 2022/7/25 17:39
 */
public interface ProcessTemplateEventListener {
  /**
   * 当流程管理新增时触发
   *
   * @param vo 流程管理信息
   */
  void onCreate(ProcessTemplateVo vo);

  /**
   * 当流程管理修改时触发
   *
   * @param oldVo 修改之前的vo
   * @param newVo 修改之后的vo
   */
  void onUpdate(ProcessTemplateVo oldVo, ProcessTemplateVo newVo);

  /**
   * 当流程管理删除时触发
   *
   * @param voList 删除vo信息
   */
  void onDelete(List<ProcessTemplateVo> voList);

  /**
   * 当流程管理发布时触发
   *
   * @param voList 删除vo信息
   */
  void onRelease(List<ProcessTemplateVo> voList);
}
