package com.biz.crm.workflow.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessMappingDto;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessMappingVo;
import org.springframework.data.domain.Pageable;

import java.util.Collection;
import java.util.List;

/**
 * 业务流程关联表;(bpm_process_business_mapping)表服务接口
 *
 * @author : Keller
 * @date : 2022-8-24
 */
public interface ProcessBusinessMappingService {

  /**
   * 分页查询数据
   *
   * @param pageable 分页对象
   * @param dto      实体对象
   */
  Page<ProcessBusinessMappingVo> findByConditions(Pageable pageable, ProcessBusinessMappingDto dto);

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  ProcessBusinessMappingVo findById(String id);

  /**
   * 通过主键查询多条数据
   *
   * @param ids 主键集合
   * @return 多条数据
   */
  List<ProcessBusinessMappingVo> findByIds(Collection<String> ids);

  /**
   * 新增数据
   *
   * @param processBusinessMappingDto 实体对象
   * @return 新增结果
   */
  ProcessBusinessMappingVo create(ProcessBusinessMappingDto processBusinessMappingDto);

  /**
   * 根据业务编号及流程状态查询关联数据信息
   *
   * @param processBusinessNo
   * @param processStatus
   * @return
   */
  ProcessBusinessMappingVo findProcessByBusinessNoAndBusinessCodeAndProcessKeyAndProcessStatus(String processBusinessNo, String processBusinessCode, String processKey, String processStatus);

  /**
   * 根据id更新流程状态
   *
   * @param id
   * @param processStatus
   */
  void updateProcessStatusById(String id, String processStatus);

  /**
   * 根据id更新流程审批状态
   *
   * @param id
   * @param dto
   */
  default void updateProcessStatusById(String id,ProcessStatusDto dto) {};

  /**
   * 更新流程的表单的可编辑状态
   *
   * @param id
   * @param canEdit
   * @param taskId
   * @param taskName
   */
  void updateCanEditById(String id, Boolean canEdit, String taskId, String taskName);

  /**
   * 通过业务流程编号以及业务编号查询
   *
   * @param dto
   * @return
   */
  ProcessBusinessMappingVo findSignalByConditions(ProcessBusinessMappingDto dto);

  /**
   * 通过业务流程编号以及业务编号查询
   *
   * @param dto
   * @return
   */
  List<ProcessBusinessMappingVo> findMultiByByConditions(ProcessBusinessMappingDto dto);

  /**
   * 逻辑删除数据
   */
  void deleteByBusinessNoAndBusinessCodeAndProcessKey(String processBusinessNo, String processBusinessCode, String processKey);

  /**
   * 根据流程编码查询流程状态
   * @param processNumber
   * @return
   */
  String findProcessStatusByProcessNumber(String processNumber);


  /**
   * 更新流程的表单信息
   *
   * @param dto
   */
  default void updateByProcessStatusDto(ProcessStatusDto dto) {};
}
