package com.biz.crm.workflow.sdk.strategy.extensionfield;



import java.util.Map;

/**
 * @description: 流程扩展字段 注：一旦实现了此扩展字段接口 在对应业务端发起则必传此项 否则会验证报错
 * @author: rentao
 * @date: 2022/8/2 14:56
 */
public interface ProcessExtensionFieldStrategy {

    /**
     * 这个方法将返回扩展字段编码 对应业务端传过来的字段
     * @return
     */
    String getProcessExtensionFieldCode();

    /**
     * 这个方法将返回扩展字段名称
     * @return
     */
    String getProcessExtensionFieldDesc();

    /**
     * 这个方法将返回具体流程扩展字段控制菜单编码
     * @return
     */
    String getFunctionCode();

    /**
     * 这个方法将返回具体流程扩展字段控制菜单名称不是全局唯一的
     * @return
     */
    String getFunctionName();

    /**
     * 这个方法将返回具体流程扩展字段控制表单编码
     * @return
     */
    String getParentCode();

    /**
     * 该方法将返回验证扩展字段条件的具体实现和提示
     * @return
     */
    void onValidate(Map<String, Object> params);
}
