package com.biz.crm.workflow.sdk.strategy.indicator;

import com.alibaba.fastjson.JSONObject;

/**
 * @description: 流程指标
 * @author: rentao
 * @date: 2022/8/2 14:56
 */
public interface ProcessIndicatorStrategy {

  /**
   * 这个方法将返回具体流程指标控制策略的全系统唯一类型编号，注意：如果系统中类型编号重复，则系统启动时会报错
   * @return
   */
  String getProcessIndicatorCode();

  /**
   * 这个方法将返回具体流程指标控制菜单编码 不是全局唯一的
   * @return
   */
  String getFunctionSubCode();

  /**
   * 这个方法将返回具体流程指标控制菜单名称不是全局唯一的
   * @return
   */
  String getFunctionSubName();

  /**
   * 该方法将返回这个具体流程指标控制策略的中文说明信息
   * @return
   */
  String getProcessIndicatorDesc();

  /**
   * 该方法将返回验证指标条件的具体实现和提示
   * @return
   */
  String onValidate(JSONObject jsonObject);
}
