package com.biz.crm.workflow.sdk.strategy.scope;

import com.biz.crm.workflow.sdk.vo.ProcessTemplateVo;
import java.util.Set;

/**
 * @description: 流程适用范围 可以使用的用户范围选择策略，每一个ApplicationUserScopeStrategy接口的实现，就是一个具体的客户范围控制策略
 * @author: rentao
 * @date: 2022/7/25 15:38
 */
public interface ApplicationUserScopeStrategy {
  /**
   * 这个方法将返回具体流程适用范围控制策略的全系统唯一类型编号，注意：如果系统中类型编号重复，则系统启动时会报错
   * @return
   */
  String getProcessUserScopeType();
  /**
   * 该方法将返回这个具体流程适用范围控制策略的中文说明信息
   * @return
   */
  String getProcessUserScopeDesc();
  /**
   * 该方法将返回排序
   * @return
   */
  Integer getIndex();
  /**
   * 流程新增，编辑时该方法会被触发该方法会被触发
   * @param update 表示当前流程绘制信息是被创建还是被修改，true表示是修改；其它值表示是创建
   * @param currentProcessTemplate 当前正在进行维护的流程绘制基本信息（且这个基本信息已经维护成功）
   * @param oldProcessTemplate 如果update为true，那么oldSalePolicy描述了修改前的流程绘制详细信息（包括所有的关联信息）
   */
  void onSaveApplicationUserScopeInfo(boolean update , ProcessTemplateVo currentProcessTemplate , ProcessTemplateVo oldProcessTemplate);
  /**
   * 通过登录信息获取processKey （登录信息获取方式）
   * @return 通过组织查询出的对应的主表编码
   */
  Set<String> onRequestProcessByLoginDetail();

}
