package com.biz.crm.workflow.sdk.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

/**
 * 描述：</br>流程业务视图，能够查看流程业务的基础信息
 *
 * @author keller
 * @date 2022/8/29
 */
@Getter
@Setter
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class ProcessBusinessVo {
  /**
   * 流程编号
   */
  private String processNo;
  /**
   * 流程key
   */
  private String processKey;

  /**
   * 流程主题
   */
  private String processTitle;
  /**
   * 业务编号
   */
  private String businessNo;
  /**
   * 应用名称
   */
  private String applicationName;
  /**
   * 业务编号
   */
  private String businessCode;
  /**
   * 流程状态
   */
  private String processStatus;

  /**
   * 流程备注
   */
  private String remark;

  /**
   * 跳过发起流程（当未启用流程的时候该值为true）
   */
  private boolean skipped;
}
