package com.biz.crm.workflow.sdk.vo;

import com.alibaba.fastjson.JSONArray;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Collection;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * @description: 流程明细数据Vo
 * @author: rentao
 * @date: 2022/8/24 14:29
 */
@Getter
@Setter
@ApiModel(value = "ProcessDataDetailVo", description = "流程明细数据Vo")
public class ProcessDataDetailVo {

  @ApiModelProperty("当前任务id")
  private String taskId;

  /**
   * 是否可编辑
   */
  @ApiModelProperty(name = "canEdit", notes = "是否可编辑", value = "是否可编辑")
  private Boolean canEdit;

  /**
   * 业务表单编码 数据来源于前端
   */
  @ApiModelProperty("业务表单编码")
  private String formCode;

  /**
   * 业务表单名称 数据来源于表单引擎
   */
  @ApiModelProperty("业务表单名称")
  private String formName;

  /*
  * 流程附件
  * */
  @ApiModelProperty("流程附件")
  private List<ProcessInstanceFilesVo> processInstanceFilesVos;

  /**
   * 用户节点审批人数据
   */
  @ApiModelProperty(name = "processTaskButtons", notes = "用户节点按钮数据", value = "用户节点按钮数据")
  private List<ProcessTaskButtonVo> processTaskButtons;

  /*
  * 备注
  * */
  @ApiModelProperty("备注")
  private String remarks;

  /*
   * 指标内容 key 指标标题 value值
   * */
  @ApiModelProperty("指标内容 key 指标标题 value值")
  private JSONArray indicatorsValue;

  /*
   * 是否可进行审批(存在待确认的沟通)
   * */
  @ApiModelProperty("是否可进行审批")
  private boolean canComplete;

  /**
   * 任务节点可编辑字段配置
   */
  @ApiModelProperty("任务节点可编辑字段配置")
  private Collection<String> processTaskEditFields;
}
