package com.biz.crm.workflow.sdk.vo;

import com.bizunited.nebula.event.sdk.model.EventResponse;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

/**
 * 描述：</br>流程发起返回数据，接入工作流的模块在发起流程时候返回的流程数据Vo
 *
 * @author keller
 * @date 2022/8/24
 */
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ProcessInfoResponse extends EventResponse {

  /**
   * 流程编号
   */
  private String processNo;

  /**
   * 流程key
   */
  private String processKey;

  /**
   * 业务编号
   */
  private String businessNo;

  /** 流程状态 */
  @ApiModelProperty(name = "processStatus",notes = "流程状态", value= "流程状态")
  private String processStatus;

  /** 流程备注 */
  private String remark;
  /** 待审批人账号(逗号分隔) */
  private String candidateUserAccounts;
  /** 待审批人名称逗号分隔) */
  private String candidateUserNames;
  /** 是否可编辑 */
  private Boolean canEdit;
  /** 流程节点编号 */
  private String taskId;
  /** 流程节点名称 */
  private String taskName;

}
