package com.biz.crm.workflow.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.bizunited.nebula.common.vo.TenantVo;
import lombok.Getter;
import lombok.Setter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.io.Serializable;
import java.util.Date;

/**
 * Vo：流程沟通;
 * @author : jerry7
 * @date : 2022-8-16
 */
@ApiModel(value = "ProcessTaskCommunicateEntity",description = "流程沟通")
@Getter
@Setter
public class ProcessTaskCommunicateVo extends TenantFlagOpVo {
  /** 主键 */
  @ApiModelProperty(name = "id",notes = "主键", value= "主键")
  private String id;
  /** 沟通内容 */
  @ApiModelProperty(name = "content",notes = "沟通内容", value= "沟通内容")
  private String content;
  /** 流程实例id */
  @ApiModelProperty(name = "processInstanceId",notes = "流程实例id", value= "流程实例id")
  private String processInstanceId;
  /** 沟通任务状态(1=未处理2=已确认) */
  @ApiModelProperty(name = "status",notes = "沟通任务状态(1=未处理2=已确认)", value= "沟通任务状态(1=未处理2=已确认)")
  private String status;
  /** 业务编码 */
  @ApiModelProperty(name = "businessFormNo",notes = "业务编码", value= "业务编码")
  private String businessFormNo;
  /** 流程key */
  @ApiModelProperty(name = "processKey",notes = "流程key", value= "流程key")
  private String processKey;
  /** 流程任务id */
  @ApiModelProperty(name = "taskId",notes = "流程任务id", value= "流程任务id")
  private String taskId;
  /** 任务节点定义key */
  @ApiModelProperty(name = "taskDefKey",notes = "任务节点定义key", value= "任务节点定义key")
  private String taskDefKey;
  /** 任务节点名称 */
  @ApiModelProperty(name = "taskName",notes = "任务节点名称", value= "任务节点名称")
  private String taskName;
  /** 目标用户编码 */
  @ApiModelProperty(name = "targetUserCode",notes = "目标用户编码", value= "目标用户编码")
  private String targetUserCode;
  /** 目标用户名称 */
  @ApiModelProperty(name = "targetUserName",notes = "目标用户名称", value= "目标用户名称")
  private String targetUserName;
  /** 目标职位编码 */
  @ApiModelProperty(name = "targetPosCode",notes = "目标职位编码", value= "目标职位编码")
  private String targetPosCode;
  /** 目标职位名称 */
  @ApiModelProperty(name = "targetPosName",notes = "目标职位名称", value= "目标职位名称")
  private String targetPosName;
  /** 是否确认沟通后才能审批 */
  @ApiModelProperty(name = "needComplete",notes = "是否确认沟通后才能审批", value= "是否确认沟通后才能审批")
  @Column(name = "need_complete",  columnDefinition = "VARCHAR(5) COMMENT '是否确认沟通后才能审批 '")
  private String needComplete;
  /** 流程状态 */
  @ApiModelProperty(name = "processStatus",notes = "流程状态", value= "流程状态")
  private String processStatus;
  /** 沟通回复内容 */
  @ApiModelProperty(name = "replyContent",notes = "沟通回复内容", value= "沟通回复内容")
  private String replyContent;

  /** 流程标题 */
  @ApiModelProperty(name = "processTitle",notes = "流程标题", value = "流程标题")
  private String processTitle;
}