package com.biz.crm.workflow.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Collection;
import java.util.Date;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @author Kevin
 * @title ProcessTaskCopyStrategyVo
 * @date 2023/5/4 9:43
 * @description
 */
@Data
@ApiModel("流程抄送寻人策略vo")
public class ProcessTaskCopyStrategyVo extends TenantVo {

  /**
   * 修改人名称
   */
  @ApiModelProperty(name = "modifyName", notes = "修改人名称", value = "修改人名称")
  private String modifyName;
  /**
   * 修改人账号
   */
  @ApiModelProperty(name = "modifyAccount", notes = "修改人账号", value = "修改人账号")
  private String modifyAccount;
  /**
   * 修改时间
   */
  @ApiModelProperty(name = "modifyTime", notes = "修改时间", value = "修改时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date modifyTime;
  /**
   * 创建人名称
   */
  @ApiModelProperty(name = "createName", notes = "创建人名称", value = "创建人名称")
  private String createName;
  /**
   * 创建时间
   */
  @ApiModelProperty(name = "createTime", notes = "创建时间", value = "创建时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;
  /**
   * 创建人账号
   */
  @ApiModelProperty(name = "createAccount", notes = "创建人账号", value = "创建人账号")
  private String createAccount;
  /**
   * 流程模板编号
   */
  @ApiModelProperty(name = "templateId", notes = "流程模板编号", value = "流程模板编号")
  private String templateId;
  /**
   * 流程节点编号
   */
  @ApiModelProperty(name = "nodeId", notes = "流程节点编号", value = "流程节点编号")
  private String nodeId;
  /**
   * 策略编号
   */
  @ApiModelProperty(name = "strategyCode", notes = "策略编号", value = "策略编号")
  private String strategyCode;
  /**
   * 策略名称
   */
  @ApiModelProperty(name = "strategyName", notes = "策略名称", value = "策略名称")
  private String strategyName;
  /**
   * 排序
   */
  @ApiModelProperty(name = "sort", notes = "排序", value = "排序")
  private Integer sort;

  /**
   * 用户节点抄送固定策略寻人详情
   */
  @ApiModelProperty(name = "processTaskCopyStrategyVars", notes = "用户节点抄送固定策略寻人详情", value = "用户节点固定抄送策略寻人详情")
  private Collection<ProcessTaskCopyStrategyVarVo> processTaskCopyStrategyVars;

}
