package com.biz.crm.workflow.sdk.vo;

import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.biz.crm.business.common.sdk.dto.UuidDto;
import com.biz.crm.business.common.sdk.vo.TenantOpVo;
import com.biz.crm.business.common.sdk.vo.UuidVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import lombok.Getter;
import lombok.Setter;

/**
 * @description: 流程关联业务vo
 * @author: rentao
 * @date: 2022/8/8 11:41
 */
@Getter
@Setter
@ApiModel(value = "ProcessTemplateBusinessVo", description = "流程关联业务vo")
public class ProcessTemplateBusinessVo extends UuidVo {

  /**
   * 流程模板id
   */
  @ApiModelProperty(name = "processTemplateId", notes = "流程模板id", value = "流程模板id")
  private String processTemplateId;

  /**
   * 流程主题  数据来源于表单引擎
   */
  @ApiModelProperty("流程主题")
  private String processTheme;

  /**
   * 流程主题json  数据来源于表单引擎
   */
  @ApiModelProperty("流程主题json")
  private String processThemeJson;

  /**
   * 业务菜单编码  数据来源于表单引擎
   */
  @ApiModelProperty("业务菜单编码")
  private String businessCode;

  /**
   * 业务表单编码 数据来源于前端
   */
  @ApiModelProperty("业务表单编码")
  private String formCode;

  /**
   * 业务表单名称 数据来源于表单引擎
   */
  @ApiModelProperty("业务表单名称")
  private String formName;

  /**
   * 生效范围  com.biz.crm.workflow.sdk.enums.EffectiveScopeEnum
   */
  @ApiModelProperty("生效范围")
  private String effectiveScope;

}
