package com.biz.crm.workflow.sdk.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import javax.persistence.Column;
import lombok.Getter;
import lombok.Setter;

/**
 * @description: 流程节点短信
 * @author: rentao
 * @date: 2022/8/3 10:33
 */
@ApiModel(value = "ProcessTemplateNodeSmsVo", description = "流程节点短信")
@Getter
@Setter
public class ProcessTemplateNodeSmsVo implements Serializable {

  /**
   * 主键
   */
  @ApiModelProperty(name = "id", notes = "主键", value = "主键")
  private String id;

  /**
   * 租户编号
   */
  @ApiModelProperty(name = "tenantCode", notes = "租户编号", value = "租户编号")
  private String tenantCode;

  /**
   * 创建人账号
   */
  @ApiModelProperty(name = "createAccount", notes = "创建人账号", value = "创建人账号")
  private String createAccount;

  /**
   * 创建人名称
   */
  @ApiModelProperty(name = "createName", notes = "创建人名称", value = "创建人名称")
  private String createName;

  /**
   * 创建时间
   */
  @ApiModelProperty(name = "createTime", notes = "创建时间", value = "创建时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;

  /**
   * 流程模板编号
   */
  @ApiModelProperty(name = "templateId", notes = "流程模板编号", value = "流程模板编号")
  private String templateId;

  /**
   * 流程节点编号
   */
  @ApiModelProperty(name = "nodeId", notes = "流程节点编号", value = "流程节点编号")
  private String nodeId;

  /**
   * 收件人类型  来自策略模式
   */
  @ApiModelProperty(name = "to_user_type", notes = "收件人", value = "收件人")
  private String toUserType;

  /**
   * 短信模板编码 取自数据字典
   */
  @ApiModelProperty(name = "smsTemplateCode", notes = "短信模板编码", value = "短信模板编码")
  private String smsTemplateCode;

  /**
   * 内容
   */
  @ApiModelProperty(name = "content", notes = "内容展示用", value = "内容展示用")
  private String content;

  /**
   * 字段对应json
   * 模块本身的样子 例如 ：{code}进销商，{name}的订单已发货请及时查收；
   * 填充后的内容    {custermercode}进销商，{ordercode+sss}的订单已发货请及时查收；
   * 这里保存的是    {"code":"custermercode","name":"ordercode+sss"} 的字符串
   */
  @ApiModelProperty(name = "contentJsonStr", notes = "字段对应json "
      + "   模块本身的样子 例如 ：{code}进销商，{name}的订单已发货请及时查收 "
      + "   填充后的内容    {custermercode}进销商，{ordercode+sss}的订单已发货请及时查收 "
      + "   这里保存的是    {\"code\":\"custermercode\",\"name\":\"ordercode+sss\"} 的字符串", value = "字段对应json")
  private String contentJsonStr;

  /**
   * 发件人信息
   */
  @ApiModelProperty(name = "processTemplateNodeSmsUserVos", notes = "发件人信息", value = "发件人信息")
  private Collection<ProcessTemplateNodeSmsUserVo> processTemplateNodeSmsUsers;
}
