package com.biz.crm.workflow.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.Date;
import java.util.List;

/**
 * @description: 流程绘制管理vo
 * @author: rentao
 * @date: 2022/7/25 16:38
 */
@Getter
@Setter
@ApiModel(value = "ProcessTemplateVo", description = "流程绘制管理vo")
public class ProcessTemplateVo extends TenantFlagOpVo {

  /**
   * 流程编码
   */
  @ApiModelProperty("流程编码")
  private String processKey;

  /**
   * 流程名称
   */
  @ApiModelProperty("流程名称")
  private String processName;

  /**
   * 上次发布时间
   */
  @ApiModelProperty(name = "lastTime", notes = "上次发布时间", value = "上次发布时间")
  private Date lastTime;

  /**
   * 流程定义id
   */
  @ApiModelProperty(name = "processDefinitionId", notes = "流程定义id", value = "流程定义id")
  private String processDefinitionId;

  /**
   * 发布状态 对应枚举 com.biz.crm.business.common.sdk.enums.EnableStatusEnum
   */
  @ApiModelProperty("发布状态")
  private String releaseStatus;

  /**
   * 发布状态 对应枚举 com.biz.crm.business.common.sdk.enums.EnableStatusEnum
   */
  @ApiModelProperty("版本")
  private Integer cversion;

  /**
   * 是否最新
   */
  @ApiModelProperty("是否最新")
  private Boolean newest;

  /**
   * 流程关联业务Vo
   */
  @ApiModelProperty(name = "processTemplateBusinessVo", notes = "流程关联业务Vo", value = "流程关联业务Vo")
  private ProcessTemplateBusinessVo processTemplateBusinessVo;

  /**
   * 流程xml vo
   */
  @ApiModelProperty(name = "processTemplateXmlVo", notes = "流程xml vo", value = "流程xml vo")
  private ProcessTemplateXmlVo processTemplateXmlVo;

  /**
   * 流程节点数据
   */
  @ApiModelProperty(name = "processTemplateNodes", notes = "流程节点数据", value = "流程节点数据")
  private List<ProcessTemplateNodeVo> processTemplateNodes;

  /**
   * 流程适用范围明细集合
   */
  @ApiModelProperty("流程适用范围明细集合")
  private List<ProcessTemplateScopeVo> processTemplateScopes;
}
