package com.biz.crm.workflow.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.business.common.sdk.vo.TenantVo;
import com.biz.crm.business.common.sdk.vo.UuidOpVo;
import com.biz.crm.workflow.sdk.dto.ProcessTodoDelegateDetailDto;
import javax.persistence.Column;
import lombok.Getter;
import lombok.Setter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.Date;
import java.util.List;

/**
 * Vo：流程待办委托;
 *
 * @author : jerry7
 * @date : 2022-8-30
 */
@ApiModel(value = "ProcessTodoDelegateVo", description = "流程待办委托")
@Getter
@Setter
public class ProcessTodoDelegateVo extends UuidOpVo {

  /**
   * 主键
   */
  @ApiModelProperty(name = "id", notes = "主键", value = "主键")
  private String id;

  /**
   * 开始时间
   */
  @ApiModelProperty(name = "startTime", notes = "开始时间", value = "开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startTime;

  /**
   * 流程实例id
   */
  @ApiModelProperty(name = "endTime", notes = "结束时间", value = "结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endTime;

  /**
   * 委托人
   */
  @ApiModelProperty(name = "userName", notes = "委托人", value = "委托人")
  private String userName;

  /**
   * 委托类型
   */
  @ApiModelProperty(name = "delegateType", notes = "委托类型", value = "委托类型")
  private String delegateType;

  /**
   * 委托详情
   */
  @ApiModelProperty(value = "被委托人列表")
  private List<ProcessTodoDelegateDetailVo> detailVoList;

}