package com.biz.crm.workflow.sdk.vo.response;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.workflow.sdk.vo.CustomerVo;
import com.bizunited.nebula.event.sdk.model.EventResponse;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.Collection;

/**
 * @description: 客户用户返回
 * @author: rentao
 * @date: 2022/8/10 14:50
 */
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class CustomerInfoResponse extends EventResponse {
  /**
   * 用户信息列表
   */
  @ApiModelProperty("用户信息列表")
  private Collection<CustomerVo> customerVos;

  /**
   * 用户信息列表分页
   */
  @ApiModelProperty("用户信息列表分页")
  private Page<CustomerVo> customerVoPage;
}
