package com.biz.crm.workflow.sdk.dto;

import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

/**
 * 工作流回调事件DTO
 * 业务层需根据需要对回调事件进行响应
 *
 * @author jerry7
 * @date 2021/12/23 14:50
 */
@Getter
@Setter
@ApiModel("工作流事件回调DTO")
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Deprecated
public class CallBackDto implements NebulaEventDto {
  /**
   * 业务来源，用于业务层区分是否需要处理本回调事件
   */
  @ApiModelProperty("业务来源，用于业务层区分是否需要处理本回调事件")
  private String formType;
  /**
   * 流程编号
   */
  @ApiModelProperty(value = "流程编号")
  private String processNo;
  /**
   * 业务编号
   */
  @ApiModelProperty(value = "业务编号")
  private String formNo;
  /**
   * 流程状态:0=草稿1=审批中2=已完成3=驳回4=终止5=撤销
   */
  @ApiModelProperty(value = "流程状态:0=草稿1=审批中2=已完成3=驳回4=终止5=撤销")
  private Integer processState;

  /**
   * 操作备注：审批通过/驳回时使用
   */
  @ApiModelProperty("操作备注")
  private String remark;
}
