package com.biz.crm.workflow.sdk.dto;

import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

/**
 * @description: 客户信息查询dto
 * @author: rentao
 * @date: 2022/8/10 14:58
 */
@Setter
@Getter
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class CustomerInfoDto implements NebulaEventDto {

  /**
   * 分页参数
   */
  @ApiModelProperty("分页参数")
  private int page;

  /**
   * 分页参数
   */
  @ApiModelProperty("分页参数")
  private int size;

  /**
   * 客户编码列表
   */
  @ApiModelProperty("客户编码列表")
  private List<String> customerCodes;
}
