package com.biz.crm.workflow.sdk.dto;

import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.Collection;
import java.util.Map;

/**
 * 描述：</br>流程创建参数dto 提供流程创建需要的数据
 *
 * @author keller
 * @date 2022/8/24
 */
@Getter
@Setter
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class ProcessBusinessDto implements NebulaEventDto {
  /** 流程key */
  @ApiModelProperty(value = "流程key",required = true)
  private String processKey;
  /** 流程主题 */
  @ApiModelProperty(value = "流程主题",required = true)
  private String processTitle;
  /** 业务编号 */
  @ApiModelProperty(value = "业务编号",required = true)
  private String businessNo;
  /** 业务表单数据（业务表单json数据） */
  @ApiModelProperty(value = "业务表单数据（业务表单json数据）",required = false)
  private String businessFormJson;
  /** 业务模块编号(用于区分同一个应用中存在同样业务编号的可能情况) */
  @ApiModelProperty(value = "业务模块编号(用于区分同一个应用中存在同样业务编号的可能情况)",required = false)
  private String businessCode;
  /** 流程备注 */
  @ApiModelProperty(value = "流程备注",required = false)
  private String remark;
  /** 附件信息 */
  @ApiModelProperty(value = "附件信息",required = false)
  private Collection<ProcessInstanceFilesDto> filesCodes;
  /** 自选审批人信息 */
  @ApiModelProperty(value = "自选审批人信息",required = false)
  private Map<String, Collection<ProcessUserDto>> taskAssignees;
  /** 结束节点添加抄送人 */
  @ApiModelProperty(value = "结束节点添加抄送人",required = false)
  private Map<String,Collection<ProcessUserDto>> copyConfigs;
  /** 扩展参数 */
  @ApiModelProperty(value = "扩展参数",required = false)
  private String extData;
  /** 应用名称(发起流程无需传入) */
  @ApiModelProperty(value = "应用名称(发起流程无需传入)",required = false)
  private String applicationName;
  /** 流程编号（发起流程无需传入） */
  @ApiModelProperty(value = "流程编号（发起流程无需传入）",required = false)
  private String processNo;
  /** 是否跳过流程（在未配置开启流程的情况下该属性值为：true,发起流程无需传入） */
  @ApiModelProperty(value = "是否跳过流程（在未配置开启流程的情况下该属性值为：true,发起流程无需传入）",required = false)
  private boolean skipped;
  /** 租户编号（发起流程无需传入） */
  @ApiModelProperty(value = "租户编号（发起流程无需传入）",required = false)
  private String tenantCode;
}
