package com.biz.crm.workflow.sdk.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;

/**
 * 参数传递dto：业务流程关联表;
 * @author : Keller
 * @date : 2022-8-24
 */
@ApiModel(value = "BpmProcessBusinessMapping",description = "业务流程关联表")
@Getter
@Setter
public class ProcessBusinessMappingDto implements Serializable{
  /** 主键 */
  @ApiModelProperty(name = "id",notes = "主键", value = "主键")
  private String id;
  /** 租户编号 */
  @ApiModelProperty(name = "tenantCode",notes = "租户编号", value = "租户编号")
  private String tenantCode;
  /** 创建时间 */
  @ApiModelProperty(name = "createTime",notes = "创建时间", value = "创建时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;
  /** 修改人名称 */
  @ApiModelProperty(name = "modifyName",notes = "修改人名称", value = "修改人名称")
  private String modifyName;
  /** 修改人账号 */
  @ApiModelProperty(name = "modifyAccount",notes = "修改人账号", value = "修改人账号")
  private String modifyAccount;
  /** 修改时间 */
  @ApiModelProperty(name = "modifyTime",notes = "修改时间", value = "修改时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date modifyTime;
  /** 创建人名称 */
  @ApiModelProperty(name = "createName",notes = "创建人名称", value = "创建人名称")
  private String createName;
  /** 创建人账号 */
  @ApiModelProperty(name = "createAccount",notes = "创建人账号", value = "创建人账号")
  private String createAccount;
  /** 备注 */
  @ApiModelProperty(name = "remark",notes = "备注", value = "备注")
  private String remark;
  /** 业务编号 */
  @ApiModelProperty(name = "businessNo",notes = "业务编号", value = "业务编号")
  private String businessNo;
  /** 流程编号 */
  @ApiModelProperty(name = "processNo",notes = "流程编号", value = "流程编号")
  private String processNo;
  /** 流程key */
  @ApiModelProperty(name = "processKey",notes = "流程key", value = "流程key")
  private String processKey;
  /** 流程状态 */
  @ApiModelProperty(name = "processStatus",notes = "流程状态", value = "流程状态")
  private String processStatus;
  /** 应用名称 */
  @ApiModelProperty(name = "applicationName",notes = "应用名称", value = "应用名称")
  private String applicationName;
  /** 业务编号 */
  @ApiModelProperty(name = "businessCode",notes = "业务编号", value = "业务编号")
  private String businessCode;
  /** 是否可编辑 */
  @ApiModelProperty(name = "canEdit",notes = "是否可编辑", value= "是否可编辑")
  private Boolean canEdit;
  /** 流程节点编号 */
  @ApiModelProperty(name = "taskId",notes = "流程节点编号", value= "流程节点编号")
  private String taskId;
  /** 流程节点名称 */
  @ApiModelProperty(name = "taskName",notes = "流程节点名称", value= "流程节点名称")
  private String taskName;
  /** 业务编号集合 */
  @ApiModelProperty(name = "businessNos",notes = "业务编号", value = "业务编号")
  private Collection<String> businessNos;

}
