package com.biz.crm.workflow.sdk.dto;

import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.workflow.sdk.vo.ProcessDelegateMandataryConfigDetailVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.util.Date;
import java.util.List;

/**
 * @author : rentao
 * @date : 2022/11/23 17:47
 */
@ApiModel(value = "ProcessDelegateConfigDto", description = "流程委托配置Dto")
@Getter
@Setter
public class ProcessDelegateConfigDto extends TenantFlagOpDto {


  /**
   * 委托配置编码
   */
  @ApiModelProperty(name = "delegateConfigCode", notes = "委托配置编码", value = "委托配置编码")
  private String delegateConfigCode;

  /**
   * 开始时间
   */
  @ApiModelProperty(name = "startTime", notes = "开始时间", value = "开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startTime;

  /**
   * 结束时间
   */
  @ApiModelProperty(name = "endTime", notes = "结束时间", value = "结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endTime;

  /**
   * 委托人类型
   */
  @ApiModelProperty(name = "delegateType", notes = "委托人类型", value = "委托人类型")
  private String delegatePersonType;

  /**
   * 委托人类型名称
   */
  @ApiModelProperty(name = "delegatePersonName", notes = "委托人类型名称", value = "委托人类型名称")
  private String delegatePersonName;

  /**
   * 委托方式
   */
  @ApiModelProperty(name = "processDelegateTypeCode", notes = "委托方式编码", value = "委托方式编码")
  private String processDelegateTypeCode;

  /**
   * 委托方式
   */
  @ApiModelProperty(name = "processDelegateTypeDesc", notes = "委托方式名称", value = "委托方式名称")
  private String processDelegateTypeDesc;

  /**
   * 是否全部流程
   */
  @ApiModelProperty(name = "canAllProcess", notes = "是否全部流程", value = "是否全部流程")
  private Boolean canAllProcess;

  /**
   * 是否抄送委托人
   */
  @ApiModelProperty(name = "canCopy", notes = "是否抄送委托人", value = "是否抄送委托人")
  private Boolean canCopy;

  /** 生效状态 */
  @ApiModelProperty(name = "delegateConfigStatus",notes = "生效状态", value= "生效状态")
  private String delegateConfigStatus;

  /**
   * 流程委托配置明细Dto
   */
  @ApiModelProperty(name = "details", notes = "流程委托配置明细Dto", value = "流程委托配置明细Dto")
  private List<ProcessDelegateConfigDetailDto> details;

  /**
   * 流程被委托配置明细Dto
   */
  @ApiModelProperty(name = "details", notes = "流程被委托配置明细Dto", value = "流程被委托配置明细Dto")
  private List<ProcessDelegateMandataryConfigDetailDto> mandataryDetails;

  /**
   * 流程委托配置模板明细Dto
   */
  @ApiModelProperty(name = "templateDetails", notes = "流程委托配置模板明细Dto", value = "流程委托配置模板明细Dto")
  private List<ProcessDelegateConfigTemplateDetailDto> templateDetails;
}
