package com.biz.crm.workflow.sdk.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * 参数传递dto：流程实例指定审批人;
 * @author : Keller
 * @date : 2022-8-24
 */
@ApiModel(value = "ProcessInstanceAssignee",description = "流程实例指定审批人")
@Getter
@Setter
public class ProcessInstanceAssigneeDto implements Serializable{
  /** 主键 */
  @ApiModelProperty(name = "id",notes = "主键", value = "主键")
  private String id;
  /** 租户编号 */
  @ApiModelProperty(name = "tenantCode",notes = "租户编号", value = "租户编号")
  private String tenantCode;
  /** 创建时间 */
  @ApiModelProperty(name = "createTime",notes = "创建时间", value = "创建时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;
  /** 修改人名称 */
  @ApiModelProperty(name = "modifyName",notes = "修改人名称", value = "修改人名称")
  private String modifyName;
  /** 修改人账号 */
  @ApiModelProperty(name = "modifyAccount",notes = "修改人账号", value = "修改人账号")
  private String modifyAccount;
  /** 修改时间 */
  @ApiModelProperty(name = "modifyTime",notes = "修改时间", value = "修改时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date modifyTime;
  /** 创建人名称 */
  @ApiModelProperty(name = "createName",notes = "创建人名称", value = "创建人名称")
  private String createName;
  /** 创建人账号 */
  @ApiModelProperty(name = "createAccount",notes = "创建人账号", value = "创建人账号")
  private String createAccount;
  /** 备注 */
  @ApiModelProperty(name = "remark",notes = "备注", value = "备注")
  private String remark;
  /** 流程实例id */
  @ApiModelProperty(name = "processInstanceId",notes = "流程实例idkey", value = "流程实例idkey")
  private String processInstanceId;
  /** 流程任务id */
  @ApiModelProperty(name = "processTaskId",notes = "流程任务id", value = "流程任务id")
  private String processTaskId;
  /** 审批人编号 */
  @ApiModelProperty(name = "assigneeCode",notes = "审批人编号", value = "审批人编号")
  private String assigneeCode;
  /** 审批人名称 */
  @ApiModelProperty(name = "assigneeName",notes = "审批人名称", value = "审批人名称")
  private String assigneeName;
}
